#include <cstdio>
#include <cstring>
#include <algorithm>
#include <random>
#include <cassert>
#include <vector>

std::mt19937 rng(228);
const int N = 400;
int n, m, cnt[N][N], a[N * N], p[N * N], aa[N * N], ccnt[N][N], ordm[N], ordn[N];

std::vector<std::pair<int, int> > solve() {
	memcpy(cnt, ccnt, sizeof cnt);
	memcpy(a, aa, sizeof a);
	std::vector<std::pair<int, int> > ans;
	std::shuffle(p, p + n * m, rng);
	for (int i = 0; i < m; ++i) ordm[i] = i;
	std::shuffle(ordm, ordm + m, rng);
	for (int i = 0; i < n; ++i) ordn[i] = i;
	std::shuffle(ordn, ordn + n, rng);
	for (int id = 0; id < n * m; ++id) {
		int i = p[id];
		if (cnt[i / m][a[i]] > 1) {
			std::shuffle(ordn, ordn + n, rng);
			std::shuffle(ordm, ordm + m, rng);
			std::vector<int> p;
			int j = i, cur = -1;
			while (true) {
				p.push_back(j);
				--cnt[j / m][a[j]];
				std::swap(a[j], cur);
				if (a[j] != -1) ++cnt[j / m][a[j]];
				int to;
				for (to = 0; to < n && (ordn[to] == i / m || cnt[ordn[to]][cur]); ++to);
				if (to == n) to = i / m;
				else to = ordn[to];
				if (to == i / m) {
					for (j = 0; j < m && (a[to * m + ordm[j]] == -1 || cnt[to][a[to * m + ordm[j]]] == 1); ++j);
					if (j == m) break;
				} else for (j = 0; cnt[to][a[to * m + ordm[j]]] == 1; ++j);
				j = to * m + ordm[j];
			}
			a[i] = cur;
			++cnt[i / m][a[i]];
			ans.push_back(std::make_pair(p.back() + 1, n * m + 1));
			for (int i = p.size() - 2; i >= 0; --i) ans.push_back(std::make_pair(p[i] + 1, p[i + 1] + 1));
			ans.push_back(std::make_pair(n * m + 1, p.front() + 1));
		}
	}
	return ans;
}

int main() {
	scanf("%d%d", &n, &m);
	for (int i = 0; i < n * m; ++i) {
		scanf("%d", a + i);
		--a[i];
		++cnt[i / m][a[i]];
		p[i] = i;
	}
	memcpy(aa, a, sizeof a);
	memcpy(ccnt, cnt, sizeof cnt);
	std::vector<std::pair<int, int> > ans = solve();
	for (int it = 0; (double)clock() / CLOCKS_PER_SEC < 0.8; ++it) {
		std::vector<std::pair<int, int> > ans1 = solve();
		if (ans1.size() < ans.size()) ans = ans1;
	}
	printf("%d\n", (int)ans.size());
	for (int i = 0; i < (int)ans.size(); ++i) printf("%d %d\n", ans[i].first, ans[i].second);
	return 0;
}